local function interactions_for_spec(spec)
  local grid = {}
  for i,v in pairs(spec) do
    grid_store(grid, Vector.new(i - 1, 0), 1)
    if v == 1 then
      grid_store(grid, Vector.new(i - 1, 1), 1)
    end
  end
  return fully_connected_object_interactions(grid)
end
local function is_spec_even(spec)
  local ct = 0
  for i,v in pairs(spec) do
    if v == 1 then
      ct = ct + 1
    end
  end
  return ct >= 4
end
location.std.generators[1].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct))
end
local even_pos = 0
location.std.checkers[1].dynamic = function(_)
  while not is_spec_even(get_spec(even_pos)) do
    even_pos = even_pos + 1
  end
  local ret = interactions_for_spec(get_spec(even_pos))
  even_pos = even_pos + 1
  return ret
end
local odd_pos = 0
location.std.checkers[2].dynamic = function(_)
  while is_spec_even(get_spec(odd_pos)) do
    odd_pos = odd_pos + 1
  end
  local ret = interactions_for_spec(get_spec(odd_pos))
  odd_pos = odd_pos + 1
  return ret
end

local specifications =
{{1, 0, 0, 1, 1, 0, 0, 1},
{0, 0, 1, 1, 1, 0, 0, 0},
{0, 1, 0, 1, 0, 1, 1, 1},
{0, 0, 0, 1, 0, 0, 1, 1},
{1, 0, 0, 0, 0, 1, 1, 0},
{0, 1, 1, 1, 1, 1, 0, 0},
{0, 0, 1, 0, 0, 0, 0, 1},
{1, 0, 1, 0, 0, 0, 0, 0},
{1, 0, 0, 1, 0, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 1, 0},
{1, 1, 0, 1, 1, 1, 0, 1},
{1, 1, 1, 0, 0, 0, 0, 0},
{0, 0, 1, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 1, 1, 1, 1},
{1, 1, 1, 1, 1, 1, 0, 1},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 1, 0, 0, 0, 1, 0, 1},
{1, 1, 1, 1, 0, 1, 0, 1},
{1, 0, 0, 0, 0, 1, 0, 0},
{1, 1, 0, 0, 1, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 0, 1},
{0, 1, 1, 1, 0, 1, 1, 1},
{0, 0, 1, 0, 1, 1, 1, 0},
{1, 1, 0, 0, 0, 0, 0, 1},
{1, 0, 1, 0, 0, 0, 0, 1},
{0, 1, 0, 1, 0, 1, 1, 1},
{1, 0, 1, 0, 0, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 1, 0},
{0, 0, 0, 1, 1, 0, 1, 0},
{0, 1, 0, 1, 0, 1, 1, 0},
{0, 1, 0, 0, 0, 1, 1, 1},
{0, 1, 0, 1, 0, 0, 1, 1},
{1, 0, 1, 1, 1, 0, 0, 0},
{1, 0, 0, 1, 1, 1, 0, 1},
{1, 1, 0, 0, 1, 1, 0, 1},
{1, 1, 0, 1, 0, 0, 0, 0},
{1, 0, 1, 0, 0, 1, 1, 0},
{1, 1, 0, 1, 0, 1, 0, 0},
{1, 0, 1, 1, 1, 0, 0, 0},
{1, 0, 0, 1, 0, 0, 1, 0},
{0, 1, 1, 0, 0, 0, 0, 0},
{0, 1, 1, 0, 0, 1, 1, 1},
{0, 0, 1, 1, 0, 0, 0, 1},
{1, 1, 0, 0, 0, 1, 0, 0},
{0, 1, 0, 0, 1, 1, 0, 0},
{0, 1, 0, 0, 0, 0, 0, 1},
{0, 1, 0, 0, 0, 0, 0, 1},
{1, 0, 0, 1, 0, 0, 1, 1},
{0, 1, 0, 0, 1, 0, 0, 0},
{0, 0, 0, 1, 0, 1, 0, 1},
{1, 0, 0, 0, 1, 0, 1, 0},
{1, 0, 1, 0, 1, 1, 0, 1},
{0, 0, 0, 1, 1, 1, 0, 0},
{0, 0, 1, 1, 1, 1, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 0},
{0, 0, 1, 1, 1, 0, 0, 0},
{1, 1, 1, 1, 1, 0, 1, 0},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 0, 1, 1, 0, 1, 1, 0},
{1, 0, 1, 1, 1, 1, 1, 0},
{1, 1, 0, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 1, 0, 0, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{0, 0, 0, 0, 1, 1, 0, 0},
{0, 1, 1, 0, 1, 1, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0},
{0, 1, 1, 0, 0, 0, 0, 0},
{0, 0, 1, 0, 0, 0, 0, 0},
{0, 1, 1, 1, 0, 1, 0, 1},
{0, 1, 0, 1, 1, 0, 0, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{1, 1, 0, 1, 1, 0, 1, 1},
{1, 1, 1, 1, 1, 1, 1, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{0, 0, 1, 1, 1, 1, 0, 1},
{0, 0, 1, 0, 0, 0, 0, 1},
{1, 0, 1, 1, 0, 1, 1, 0},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 0, 1, 0, 0, 0, 0, 1},
{0, 1, 0, 0, 1, 0, 1, 1},
{1, 1, 1, 1, 0, 0, 1, 1},
{0, 1, 1, 1, 1, 0, 0, 1},
{1, 0, 0, 1, 0, 0, 1, 0},
{0, 1, 1, 1, 1, 0, 1, 0},
{0, 0, 0, 1, 1, 1, 0, 1},
{0, 1, 1, 0, 0, 1, 1, 0},
{1, 1, 0, 0, 0, 0, 1, 0},
{1, 0, 1, 0, 0, 1, 1, 0},
{0, 0, 1, 1, 1, 1, 1, 0},
{1, 0, 1, 0, 1, 0, 0, 1},
{1, 1, 1, 1, 0, 1, 1, 1},
{0, 0, 0, 1, 0, 1, 0, 0},
{0, 0, 0, 1, 0, 0, 1, 0},
{1, 1, 0, 0, 1, 0, 0, 1},
{1, 1, 1, 0, 1, 0, 0, 0},
{0, 1, 0, 0, 1, 0, 0, 1},
{0, 0, 1, 0, 1, 0, 0, 1},
{1, 0, 0, 0, 0, 0, 0, 1},
{1, 0, 1, 0, 0, 1, 0, 0}}
function get_spec(n)
  return specifications[(n % #specifications) + 1]
end
